/*********************
 * Daten aufbereiten *
 *********************/

-- Primary Key für Tabelle KSVBA anlegen, fehlte ggf. noch.
ALTER TABLE ksvba DROP CONSTRAINT IF EXISTS ksvba_pkey;
ALTER TABLE ksvba ADD PRIMARY KEY ( ksb_id );

-- KSV-Trigger triggern: Arbeitsplätze (ksvba) und KSVBA-Ressourcen anlegen bzw. synchronisieren.
-- Trigger "ksv__a_iu__sync_ksv_ba" und "ksvba_005_sync_resource_a__iu".
-- Damit ist ein späteres Anlegen der KSVBA-Ressourcen nicht mehr notwendig.
UPDATE ksv
   SET ks_id = ks_id;

-- Spalten von Tabelle "ksv" nach Tabelle "ksvba" verschieben.
ALTER TABLE ksv DROP COLUMN IF EXISTS ks_timestart;
ALTER TABLE ksv DROP COLUMN IF EXISTS ks_timeend;
ALTER TABLE ksvba ADD COLUMN IF NOT EXISTS ksb_timestart     TIME DEFAULT '08:00';
ALTER TABLE ksvba ADD COLUMN IF NOT EXISTS ksb_timeend       TIME DEFAULT '18:00';
ALTER TABLE ksvba DROP CONSTRAINT IF EXISTS max_ks_timeend;
ALTER TABLE ksvba DROP CONSTRAINT IF EXISTS max_ksb_timeend;
UPDATE ksvba SET ksb_timeend = '23:59:59'::time WHERE ksb_timeend = '24:00:00'::time;
ALTER TABLE ksvba ADD CONSTRAINT max_ksb_timeend CHECK ( (ksb_timeend < '24:00:00') AND (ksb_timestart < ksb_timeend) );

ALTER TABLE ksvba DISABLE TRIGGER ALL;
UPDATE ksvba SET ksb_timestart = '07:00', ksb_timeend = '15:45'     WHERE ksb_ks_ba <= 1.5;
UPDATE ksvba SET ksb_timestart = '05:00', ksb_timeend = '21:00'     WHERE ksb_ks_ba > 1.5 AND ksb_ks_ba <= 2.5;
UPDATE ksvba SET ksb_timestart = '00:00', ksb_timeend = '23:59:59'  WHERE ksb_ks_ba > 2.5;
ALTER TABLE ksvba ENABLE TRIGGER ALL;

-- Veraltete Spalte löschen
ALTER TABLE ksv DROP COLUMN IF EXISTS ks_nap;

-- Transportmatrix aufbauen -- DELETE FROM scheduling.resource_transport;
SELECT scheduling.ksvba__resource__transport_update( ksvba, null::ksvba ) FROM ksvba JOIN ksv ON ksb_ks_id = ks_id;

/* Ressourcen brauchen nicht extra angelegt werden, machen Trigger bei Anlage der ABKs, AGs und KSVBAs.
-- ABK-Ressourcen anlegen.
-- Müssen für alle ABKs (auch geschlossene ABKs) angelegt werden, da ab2__resource_requirements_options__ksvba__from__ab2__create das nicht repariert und ggf. benötigt wird.
INSERT INTO scheduling.resource( context, context_id )
SELECT 'abk', ab_ix
  FROM abk
;

-- AG-Ressourcen anlegen.
-- Müssen für alle AGe (auch geschlossene AGe) angelegt werden, da ab2__resource_requirements_options__ksvba__from__ab2__create das nicht repariert und ggf. benötigt wird.
INSERT INTO scheduling.resource( context, context_id )
SELECT 'ab2', a2_id
  FROM ab2
  JOIN abk ON ab_ix = a2_ab_ix
;

-- Das Ressourcen-Beziehungsnetzwerk aufbauen. (ab2__resource_requirements_options__ksvba__from__ab2__create)
SELECT ab2.a2_id
     , scheduling.ab2__resource_requirements_options__ksvba__from__ab2__create( ab2 )
  FROM ab2
  JOIN abk ON ab_ix = a2_ab_ix
          AND NOT ab_done
 WHERE NOT a2_ende
;
--
*/
-- Ausschaltzeiten in Resource_Timeline eintragen. (renew_offtime)
-- Trotz automatischer Generierung der Ausschaltzeiten (siehe Trigger ksvba_005_sync_resource_a__iu und resource_005_sync_resource_timeline_a__iu) notwendig.
-- Da notwendiges Zeitfenster für die Ausschaltzeiten hier aus Tabelle "ab2_wkstplan" bestimmt wird.
SELECT r.id
     , scheduling.resource_timeline__renew_offtime(
            -- alle ksvba-Ressourcen
            _resource_id      => r.id
            -- Standardzeitgrenzen verwenden (siehe resource_timeline__offtime__default_timeframe_start__get() und resource_timeline__offtime__default_timeframe_end__get())
            -- Früheste Planwoche der offenen AGe oder heute - 3 Monate, je nach dem, was früher wäre
          , _timeframe_start  => least( to_timestamp( min( a2w_planweek ), 'IYYYIW' )::timestamp, date_trunc( 'day', now() - interval '3 month' )::timestamp )
            -- Späteste Planwoche der offenen AGe + 1 Woche oder heute + 2 Jahre, ja nachdem, was später wäre
          , _timeframe_end    => greatest( to_timestamp( max( a2w_planweek ), 'IYYYIW' )::timestamp + interval '6 month', date_trunc( 'day', now() + interval '2 years' )::timestamp )
       )
  FROM ab2
  JOIN ab2_wkstplan ON a2w_a2_id = a2_id
  JOIN ksv ON ks_abt = a2_ks
  JOIN abk ON a2_ab_ix = ab_ix
  JOIN scheduling.resource AS r ON r.context = 'ksvba'
 WHERE a2w_planweek IS NOT null
   AND a2_interm
   AND NOT a2_ende
   AND NOT ab_done
   AND ab_inplantaf
   AND NOT ks_sperr
 GROUP BY r.id
 ORDER BY r.id
;
--


/*Resourcen in Plantafel etwas breiter!
ALTER TABLE plant_ks ADD COLUMN pt_left_new integer;
ALTER TABLE plant_ks ADD COLUMN pt_width_new integer;
*/


/*
ALTER TABLE f2poss DISABLE TRIGGER ALL;
ALTER TABLE f2rck  DISABLE TRIGGER ALL;
UPDATE f2poss SET feldname = 'mymaschines_ab_ix' WHERE modulname ILIKE 'TFormMyMaschines' AND feldname ILIKE 'ab_ix';
UPDATE f2rck  SET f2r_forcomponent = 'mymaschines_ab_ix' FROM f2poss WHERE modulname = 'TFormMyMaschines' AND feldname ILIKE 'mymaschines_ab_ix' AND f2r_f2rckfieldn ILIKE 'ab_ix';
ALTER TABLE f2poss ENABLE TRIGGER ALL;
ALTER TABLE f2rck  ENABLE TRIGGER ALL;
*/

SELECT * INTO z_99_drop.plant_ks__positions FROM plant_ks;

DO $$
DECLARE r record;
        lastgoup varchar;
        leftsum integer;
        counter integer;
BEGIN
     /*
     -- Grundsätzliche Breite ist etwas mehr
     UPDATE plant_ks SET pt_width = pt_width + 60;
     -- der Pool fliegt raus. Daher können wir die Breite reduzieren!
     UPDATE plant_ks SET pt_width = pt_width - 400 FROM ksv WHERE pt_ks = ks_abt AND (ks_planpool OR ks_abt = 'KONH5ACC'); -- KONH5ACC wurde vor Datenübernahme im LiveSystem der Pool bereits entfernt
     -- Alle Resoucen im Register durchlaufen und Left auf Basis der neuen Breite neu berechnen
     */
     UPDATE plant_ks SET pt_width = 435 * numeric_larger(tplanterm.ks_anz_maschine(pt_ks), 1);
     FOR r IN SELECT * FROM plant_ks ORDER BY pt_ptr_name, pt_left
     LOOP
         -- Gruppenwechsel = zurücksetzen
         IF lastgoup IS DISTINCT FROM r.pt_ptr_name THEN
            leftsum := 0;
         END IF;
         --
         IF leftsum > 0 THEN
            UPDATE plant_ks SET pt_left/*_new*/ = leftsum WHERE pt_id = r.pt_id;
         END IF;
         --
         leftsum := leftsum + r.pt_width/*_new*/;
         lastgoup := r.pt_ptr_name;
     END LOOP;
END $$ LANGUAGE plpgsql;

-- Alle als "Pool" markierten Kostenstellen zu "nicht Pool" umstellen.
UPDATE ksv
   SET ks_planpool = false
 WHERE ks_planpool;

-- dbrid für neue Tabellen
SELECT TSystem.tables__generate_missing_fields();

-- Materialized Views aktualisieren
DO $$
BEGIN
    -- Wenn außerhalb vom CI, dann ...
    IF current_user <> 'docker' THEN
        -- ... materialized Views aktualisieren.
        PERFORM TCache.CachedViews_Refresh();
    END IF;
END $$ LANGUAGE plpgsql;